/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.configurer.map;

import java.util.HashMap;
import java.util.Map;
import org.codefilarete.reflection.Accessor;
import org.codefilarete.reflection.AccessorChain;
import org.codefilarete.reflection.ReversibleAccessor;
import org.codefilarete.stalactite.engine.configurer.map.KeyValueRecord;
import org.codefilarete.stalactite.engine.configurer.map.KeyValueRecordMapping;
import org.codefilarete.stalactite.mapping.EmbeddedClassMapping;
import org.codefilarete.stalactite.mapping.id.assembly.IdentifierAssembler;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.collection.Maps;

class KeyValueRecordMappingBuilder<K, V, I, T extends Table<T>, LEFTTABLE extends Table<LEFTTABLE>> {
    private final T associationTable;
    private final IdentifierAssembler<I, LEFTTABLE> sourceIdentifierAssembler;
    private final Map<Column<LEFTTABLE, ?>, Column<T, ?>> primaryKeyForeignColumnMapping;
    private Column<T, K> keyColumn;
    private Column<T, V> valueColumn;
    private EmbeddedClassMapping<K, T> entryKeyMapping;
    private EmbeddedClassMapping<V, T> entryValueMapping;

    private static <K> Maps.ChainingMap<ReversibleAccessor, Column> chainWithKeyAccessor(EmbeddedClassMapping<K, ?> entryKeyMapping) {
        Maps.ChainingMap result = new Maps.ChainingMap();
        entryKeyMapping.getPropertyToColumn().forEach((keyPropertyAccessor, column) -> {
            AccessorChain key = new AccessorChain(new Accessor[]{KeyValueRecord.KEY_ACCESSOR, keyPropertyAccessor});
            key.setNullValueHandler((AccessorChain.NullValueHandler)new AccessorChain.ValueInitializerOnNullValue((accessor, inputType) -> {
                if (accessor == KeyValueRecord.KEY_ACCESSOR) {
                    return Reflections.newInstance((Class)entryKeyMapping.getClassToPersist());
                }
                return Reflections.newInstance((Class)inputType);
            }));
            result.add((Object)key, column);
        });
        return result;
    }

    private static <V> Maps.ChainingMap<ReversibleAccessor, Column> chainWithValueAccessor(EmbeddedClassMapping<V, ?> entryKeyMapping) {
        Maps.ChainingMap result = new Maps.ChainingMap();
        entryKeyMapping.getPropertyToColumn().forEach((keyPropertyAccessor, column) -> {
            AccessorChain key = new AccessorChain(new Accessor[]{KeyValueRecord.VALUE_ACCESSOR, keyPropertyAccessor});
            key.setNullValueHandler((AccessorChain.NullValueHandler)new AccessorChain.ValueInitializerOnNullValue((accessor, inputType) -> {
                if (accessor == KeyValueRecord.VALUE_ACCESSOR) {
                    return Reflections.newInstance((Class)entryKeyMapping.getClassToPersist());
                }
                return Reflections.newInstance((Class)inputType);
            }));
            result.add((Object)key, column);
        });
        return result;
    }

    KeyValueRecordMappingBuilder(T associationTable, IdentifierAssembler<I, LEFTTABLE> sourceIdentifierAssembler, Map<Column<LEFTTABLE, ?>, Column<T, ?>> primaryKeyForeignColumnMapping) {
        this.associationTable = associationTable;
        this.sourceIdentifierAssembler = sourceIdentifierAssembler;
        this.primaryKeyForeignColumnMapping = primaryKeyForeignColumnMapping;
    }

    void withEntryKeyIsSingleProperty(Column<T, K> keyColumn) {
        this.keyColumn = keyColumn;
    }

    void withEntryValueIsSingleProperty(Column<T, V> valueColumn) {
        this.valueColumn = valueColumn;
    }

    void withEntryKeyIsComplexType(EmbeddedClassMapping<K, T> entryKeyMapping) {
        this.entryKeyMapping = entryKeyMapping;
    }

    void withEntryValueIsComplexType(EmbeddedClassMapping<V, T> entryValueMapping) {
        this.entryValueMapping = entryValueMapping;
    }

    KeyValueRecordMapping<K, V, I, T> build() {
        HashMap<Object, Object> propertiesMapping = new HashMap<Object, Object>();
        KeyValueRecordMapping.KeyValueRecordIdMapping<Object, I, T> idMapping = null;
        if (this.keyColumn != null) {
            propertiesMapping.put(KeyValueRecord.KEY_ACCESSOR, this.keyColumn);
            idMapping = new KeyValueRecordMapping.KeyValueRecordIdMapping<Object, I, T>(this.associationTable, columnedRow -> columnedRow.get(this.keyColumn), k -> Maps.forHashMap(Column.class, Object.class).add(this.keyColumn, k), this.sourceIdentifierAssembler, this.primaryKeyForeignColumnMapping);
        } else if (this.entryKeyMapping != null) {
            propertiesMapping.putAll((Map<Object, Object>)KeyValueRecordMappingBuilder.chainWithKeyAccessor(this.entryKeyMapping));
            idMapping = new KeyValueRecordMapping.KeyValueRecordIdMapping<K, I, T>(this.associationTable, this.entryKeyMapping, this.sourceIdentifierAssembler, this.primaryKeyForeignColumnMapping);
        }
        if (this.valueColumn != null) {
            propertiesMapping.put(KeyValueRecord.VALUE_ACCESSOR, this.valueColumn);
        } else if (this.entryValueMapping != null) {
            propertiesMapping.putAll((Map<Object, Object>)KeyValueRecordMappingBuilder.chainWithValueAccessor(this.entryValueMapping));
        }
        return new KeyValueRecordMapping(this.associationTable, propertiesMapping, idMapping);
    }
}

